/*****************************************************************************************
* MERGING INDIVIDUAL FILES ACROSS WAVES INTO LONG FORMAT                                 *
*****************************************************************************************/

clear 

// SET WORKING DIRECTORY 

cd "/Users/amwaj-opto/Desktop/COVI19 "

//loop through each wave
foreach w in ca cb cc cd ce cf ck cg ch ci { 
	
	// find the wave number
	local waveno=strpos("abcdefghijklmnopqrstuvwxyz","`w'")
	
	// open the individual level file
	use pidp `w'_age using "`w'_indresp_w", clear
	
	
	// drop the wave prefix from all variables
	rename `w'_* *
	
	// create a wave variable
	gen wave=`waveno'
	
	// save one file for each wave
	save temp`w', replace
}

// open the file for the first wave (wave a_)
use temp ca , clear

// loop through the remaining waves
foreach w in  b c d e f g h i {

	// append the files for the second wave onwards
	append using temp`w'
}
